# -*- coding: UTF-8 -*-
from common.util import log
from common.util import util
from common.constants import COMSCRIPTFILE


def execute(devObj):
    ssh = devObj.get("SSH")
    # 防止设备踢session
    ssh.execCmdWithTimout("TMOUT=0", 20)
    inputdict = devObj.get("SettingInfo")
    nodeid = ""

    if inputdict:
        nodeid = inputdict.get("nodeid")
    if nodeid == "":
        nodeid = "null"

    # 获取系统版本
    devNode = devObj.get("devNode")
    version = devNode.getProductVersion()
    isOldVersion = True
    isOldVersion = util.IsOldVersion(version)
    if isOldVersion:
        return (True, "")

    # 执行预检查
    cmd = 'sudo %s "precheck" %s' % (COMSCRIPTFILE, nodeid)
    strRet = str((ssh.execCmdWithKeepAlive(cmd, 30, 60 * 60)).encode("utf-8"))

    # 处理检查结果
    isSuccess, retInfo = util.GetMessageInfo(devObj, strRet)
    if not isSuccess:
        log.error(devObj, "pre-check env failed, ret=%s" % strRet)
        return (False, "")

    return (True, "")
